// Title      : Group.java
// Author     : James Baird
// Created    : Thursday, 19th June 2003
// Description: Representation of a group

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Group extends DefaultHandler
{
  public Group(String identifier)
  {
    this.identifier = identifier;
  }
  
  public String getIdentifier()
  {
    return identifier;
  }
  
  public String getName()
  {
    return name;
  }
  
  public void setName(String name)
  {
    this.name = name;
  }
  
  public int getVolume()
  {
    return volume;
  }
  
  public void setVolume(int volume)
  {
    this.volume = volume;
  }
  
  public int getWindowSize()
  {
    return windowSize;
  }
  
  public void setWindowSize(int windowSize)
  {
    this.windowSize = windowSize;
  }

  public int getWindowStart()
  {
    return windowStart;
  }

  public void setWindowStart(int windowStart)
  {
    this.windowStart = windowStart;
  }
  
  public static Vector getIndex(String corpusPathname)
  {
    pathname = corpusPathname;

    Vector result = new Vector();

    try
    {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      
      SAXParser parser = factory.newSAXParser();
      
      XMLReader xmlReader = parser.getXMLReader();      
      
      ZipFile corpus = new ZipFile(corpusPathname);

      Enumeration groups = corpus.entries();
      
      while (groups.hasMoreElements())
      {
        ZipEntry entry = (ZipEntry)groups.nextElement();
        
        if (!entry.getName().equals("CorpusXML/"))
        {
          group = new Group(entry.getName());

          firstDay = "";
          
          xmlReader.setContentHandler(group);
        
          xmlReader.parse(new InputSource(new BufferedInputStream(corpus.getInputStream(entry))));
          
          group.setWindowStart(Integer.parseInt(firstDay));
          group.setWindowSize(firstDayCount);
        
          result.addElement(group);
          
System.out.print(".");
        }
      }
      
      corpus.close();
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
    catch (ParserConfigurationException e)
    {
      e.printStackTrace();
    }
    catch (SAXException e)
    {
      e.printStackTrace();
    }
    
    return result;
  }
  
  public Post getPost(int id)
  {
    Post result = null;
    
    try
    {
      if (id >= 0 && id < volume)
      {
        result = new Post(this, id);
      
        SAXParserFactory factory = SAXParserFactory.newInstance();
      
        SAXParser parser = factory.newSAXParser();
      
        XMLReader xmlReader = parser.getXMLReader();      
      
        ZipFile corpus = new ZipFile(pathname);

        xmlReader.setContentHandler(result);
        
        ZipEntry entry = corpus.getEntry(identifier);
        
        xmlReader.parse(new InputSource(new BufferedInputStream(corpus.getInputStream(entry))));
        
        corpus.close();
      }
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
    catch (ParserConfigurationException e)
    {
      e.printStackTrace();
    }
    catch (SAXException e)
    {
      e.printStackTrace();
    }
    
    return result;
  }

  public Posts getPosts(int id)
  {
    Posts result = null;
    
    try
    {
      if (id >= 0 && id < windowSize)
      {
        result = new Posts(this, id);
      
        SAXParserFactory factory = SAXParserFactory.newInstance();
      
        SAXParser parser = factory.newSAXParser();
      
        XMLReader xmlReader = parser.getXMLReader();      
      
        ZipFile corpus = new ZipFile(pathname);

        xmlReader.setContentHandler(result);
        
        ZipEntry entry = corpus.getEntry(identifier);
        
        xmlReader.parse(new InputSource(new BufferedInputStream(corpus.getInputStream(entry))));
        
        corpus.close();
      }
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
    catch (ParserConfigurationException e)
    {
      e.printStackTrace();
    }
    catch (SAXException e)
    {
      e.printStackTrace();
    }
    
    return result;
  }
  
  public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
  {
    if (qName.equals("group"))
    {
      group.setName(attributes.getValue("name"));
      
      group.setVolume(Integer.parseInt(attributes.getValue("volume")));
    }
    else if (qName.equals("post"))
    {
      String day = attributes.getValue("day");
      
      if (firstDay.equals(""))
      {
        firstDay = day;
        firstDayCount = 1;
      }
      else if (firstDay.equals(day))
        firstDayCount++;
    }
  }
  
  private static Group group;
  
  private static String pathname;
  
  private static String firstDay;
  private static int firstDayCount;
  
  private String identifier;
  private String name;
  private int volume;
  private int windowSize;
  private int windowStart;
}
